// ContentsEsc_b.cpp : CContentsEsc_b Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CContentsEsc_b, CObject, 1)



// Serialize draw data
void CContentsEsc_b::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring ())
        ar.Write(&m_Data,sizeof(m_Data)) ;
    else
        ar.Read(&m_Data,sizeof(m_Data)) ;
}

// Draw to Window
void CContentsEsc_b::Draw(CDC* pDC)
{
	CGpWinPen Pen( m_Data.cDisplayColor,m_Data.cLineStyle) ;
	CBrush Brush ;
	LOGBRUSH b = {	//NULL Bursh
		BS_NULL,0,0
	};
	Brush.CreateBrushIndirect(&b);

	CPen* pOldPen         = pDC->SelectObject((CPen* )&Pen);
	int OldBkMode         = pDC->SetBkMode( OPAQUE );
	COLORREF OldBkColor   = pDC->SetBkColor(GpToWinColor(m_Data.cBackColor));
	CBrush* pOldBrush     = pDC->SelectObject((CBrush* )&Brush);
	COLORREF OldTextColor = pDC->SetTextColor(GpToWinColor(m_Data.cDisplayColor));
	
	POINT Apexs[8] ;
	int x1,y1,x2,y2 ;

	switch(  m_Data.iCornerDirection ){
		case 0: // None
			pDC->Rectangle(m_Data.iX1,m_Data.iY1,m_Data.iX2,m_Data.iY2) ;
			break ;

		case 1: // Round
			pDC->RoundRect(m_Data.iX1,m_Data.iY1,m_Data.iX2,m_Data.iY2,m_Data.iCornerRadius,m_Data.iCornerRadius) ;
			break ;

		case 2: // Line
			if( m_Data.iX1 < m_Data.iX2 ){
				x1 = m_Data.iX1 ;
				x2 = m_Data.iX2 ;
			} else {
				x2 = m_Data.iX1 ;
				x1 = m_Data.iX2 ;
			}
			if( m_Data.iY1 < m_Data.iY2 ){
				y1 = m_Data.iY1 ;
				y2 = m_Data.iY2 ;
			} else {
				y2 = m_Data.iY1 ;
				y1 = m_Data.iY2 ;
			}
			Apexs[0].x = x1                        ; Apexs[0].y = y1 + m_Data.iCornerRadius ;
			Apexs[1].x = x1 + m_Data.iCornerRadius ; Apexs[1].y = y1                        ;
			Apexs[2].x = x2 - m_Data.iCornerRadius ; Apexs[2].y = y1                        ;
			Apexs[3].x = x2                        ; Apexs[3].y = y1 + m_Data.iCornerRadius ;
			Apexs[4].x = x2                        ; Apexs[4].y = y2 - m_Data.iCornerRadius ;
			Apexs[5].x = x2 - m_Data.iCornerRadius ; Apexs[5].y = y2                        ;
			Apexs[6].x = x1 + m_Data.iCornerRadius ; Apexs[6].y = y2                        ;
			Apexs[7].x = x1                        ; Apexs[7].y = y2 - m_Data.iCornerRadius ;
			pDC->Polygon( Apexs, 8 );
			break ;	
	}


	pDC->SetBkMode(OldBkMode );
	pDC->SetBkColor( OldBkColor );
	pDC->SelectObject(pOldPen);
	pDC->SelectObject(pOldBrush);
	pDC->SetTextColor(OldTextColor);
}

// Transmit the data to GP
int CContentsEsc_b::Transition( CMemSock* pCMemSock)
{
	return( pCMemSock->MtoMESC_b(m_Data.cDisplayColor,m_Data.cBackColor,m_Data.cLineStyle,m_Data.iCornerDirection,m_Data.iCornerRadius,m_Data.iX1,m_Data.iY1,m_Data.iX2,m_Data.iY2)) ;
}
